<?php
// Verificar se a instalação foi concluída
if (!file_exists('config.php') || filesize('config.php') < 100) {
    header('Location: install.php');
    exit;
}

// Tentar auto-deletar o arquivo de instalação
$install_files = ['install.php', 'install_success.php'];
foreach ($install_files as $file) {
    if (file_exists($file)) {
        @unlink($file);
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalação Concluída - Gestor DREEYTV</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .success-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 500px;
            border: 1px solid rgba(255,255,255,0.2);
            text-align: center;
        }
        
        .success-icon {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        h1 {
            color: #2d3748;
            margin-bottom: 15px;
        }
        
        p {
            color: #666;
            margin-bottom: 25px;
            line-height: 1.6;
        }
        
        .btn {
            display: inline-block;
            padding: 15px 30px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        .credentials {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            text-align: left;
        }
        
        .credentials h3 {
            color: #2d3748;
            margin-bottom: 10px;
        }
        
        .credentials p {
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="success-container">
        <div class="success-icon">🎉</div>
        <h1>Instalação Concluída!</h1>
        <p>O sistema Gestor DREEYTV foi instalado com sucesso.</p>
        
        <div class="credentials">
            <h3>👑 Credenciais do Administrador</h3>
            <p><strong>Usuário:</strong> admin</p>
            <p><strong>Senha:</strong> Admin@123456</p>
            <p style="color: #f56565; font-weight: 600; margin-top: 10px;">
                ⚠️ Altere a senha após o primeiro login!
            </p>
        </div>
        
        <a href="login.php" class="btn">🚀 Acessar Sistema</a>
        
        <p style="margin-top: 20px; font-size: 0.9rem; color: #888;">
            Os arquivos de instalação foram removidos automaticamente.
        </p>
    </div>
</body>
</html>